from fastapi import FastAPI, HTTPException
from pydantic import BaseModel
from datetime import datetime
from dateutil import parser

app = FastAPI(title="salas")

# reservas: lista de dicts {sala, inicio, fim}
RESERVAS = []

class ReservaIn(BaseModel):
    sala: str
    inicio: str  # ISO: 2025-11-05T19:00
    fim: str

@app.get("/health")
def health():
    return {"status": "ok"}

def conflita(sala: str, ini: datetime, fim: datetime) -> bool:
    for r in RESERVAS:
        if r["sala"] == sala:
            a1, a2 = r["inicio"], r["fim"]
            if not (fim <= a1 or ini >= a2):
                return True
    return False

@app.post("/reservas")
def reservar(req: ReservaIn):
    ini = parser.parse(req.inicio)
    fim = parser.parse(req.fim)
    if fim <= ini:
        raise HTTPException(400, "intervalo_invalido")
    if conflita(req.sala, ini, fim):
        raise HTTPException(409, "conflito_de_sala")
    RESERVAS.append({"sala": req.sala, "inicio": ini, "fim": fim})
    return {"ok": True, "total_reservas": len(RESERVAS)}
