from fastapi import FastAPI, HTTPException
from pydantic import BaseModel
from typing import Dict, Tuple

app = FastAPI(title="notas")
# chave: (turma_id, aluno_id, avaliacao) -> nota
NOTAS: Dict[Tuple[str,str,str], float] = {}

class NotaIn(BaseModel):
    turma_id: str
    aluno_id: str
    avaliacao: str
    nota: float

@app.get("/health")
def health():
    return {"status": "ok"}

@app.post("/nota")
def lancar(n: NotaIn):
    NOTAS[(n.turma_id, n.aluno_id, n.avaliacao)] = n.nota
    return {"ok": True}

@app.get("/nota/{turma_id}/{aluno_id}")
def consultar(turma_id: str, aluno_id: str):
    result = [{ "avaliacao": av, "nota": nota }
              for (t,a,av), nota in NOTAS.items() if t==turma_id and a==aluno_id]
    return {"registros": result}
