#!/usr/bin/env python3
import httpx, json

BASE = {
    "academico": "http://127.0.0.1:8010",
    "salas":     "http://127.0.0.1:8001",
    "turmas":    "http://127.0.0.1:8002",
    "notas":     "http://127.0.0.1:8003",
}

def pretty(x):
    try: return json.dumps(x, ensure_ascii=False, indent=2)
    except: return str(x)

def health():
    with httpx.Client() as c:
        for k, url in BASE.items():
            try:
                r = c.get(url + "/health", timeout=2.0)
                print(f"[{k}] {r.status_code} -> {r.json()}")
            except Exception as e:
                print(f"[{k}] ERRO: {e}")

def criar_turma():
    turma_id = input("turma_id (ex: ADS101): ").strip()
    professor = input("professor: ").strip()
    with httpx.Client() as c:
        r = c.post(BASE["turmas"] + "/turmas", json={"turma_id": turma_id, "professor": professor})
        print(r.status_code, pretty(r.json() if r.headers.get('content-type','').startswith('application/json') else r.text))

def matricular():
    turma_id = input("turma_id: ").strip()
    aluno_id = input("aluno_id: ").strip()
    with httpx.Client() as c:
        r = c.post(BASE["turmas"] + "/matriculas", json={"turma_id": turma_id, "aluno_id": aluno_id})
        print(r.status_code, pretty(r.json() if r.headers.get('content-type','').startswith('application/json') else r.text))

def listar_alunos():
    turma_id = input("turma_id: ").strip()
    with httpx.Client() as c:
        r = c.get(BASE["turmas"] + f"/turmas/{turma_id}/alunos")
        print(r.status_code, pretty(r.json() if r.headers.get('content-type','').startswith('application/json') else r.text))

def agendar_aula():
    turma_id = input("turma_id: ").strip()
    sala = input("sala (ex: LAB-01): ").strip()
    inicio = input("inicio ISO (ex: 2025-11-05T19:00): ").strip()
    fim = input("fim ISO (ex: 2025-11-05T21:00): ").strip()
    payload = {"turma_id": turma_id, "sala": sala, "inicio": inicio, "fim": fim}
    with httpx.Client() as c:
        r = c.post(BASE["academico"] + "/agendar-aula", json=payload)
        print(r.status_code, pretty(r.json() if r.headers.get('content-type','').startswith('application/json') else r.text))

def lancar_nota():
    turma_id = input("turma_id: ").strip()
    aluno_id = input("aluno_id: ").strip()
    avaliacao = input("avaliacao (ex: P1): ").strip()
    nota = float(input("nota (ex: 8.5): ").strip())
    payload = {"turma_id": turma_id, "aluno_id": aluno_id, "avaliacao": avaliacao, "nota": nota}
    with httpx.Client() as c:
        r = c.post(BASE["academico"] + "/lancar-nota", json=payload)
        print(r.status_code, pretty(r.json() if r.headers.get('content-type','').startswith('application/json') else r.text))

def consultar_notas():
    turma_id = input("turma_id: ").strip()
    aluno_id = input("aluno_id: ").strip()
    with httpx.Client() as c:
        r = c.get(BASE["notas"] + f"/nota/{turma_id}/{aluno_id}")
        print(r.status_code, pretty(r.json() if r.headers.get('content-type','').startswith('application/json') else r.text))

def menu():
    while True:
        print("\n=== MENU MICROSERVIÇOS ACADÊMICOS (v2, porta 8010) ===")
        print("1) Health (todos os serviços)")
        print("2) Criar turma")
        print("3) Matricular aluno")
        print("4) Listar alunos da turma")
        print("5) Agendar aula (via orquestrador)")
        print("6) Lançar nota (via orquestrador)")
        print("7) Consultar notas do aluno")
        print("0) Sair")
        op = input("Escolha: ").strip()
        try:
            if op == "1": health()
            elif op == "2": criar_turma()
            elif op == "3": matricular()
            elif op == "4": listar_alunos()
            elif op == "5": agendar_aula()
            elif op == "6": lancar_nota()
            elif op == "7": consultar_notas()
            elif op == "0": print("tchau!"); return
            else: print("opção inválida.")
        except Exception as e:
            print("Erro:", e)

if __name__ == "__main__":
    print("Dica: deixe 'python run_all.py' rodando em outro terminal antes de usar o menu.")
    menu()
