# Microserviços Acadêmicos (VS Code + Python) — v2 (acadêmico na porta 8010)

Portas padrão (v2):
- **acadêmico** → http://127.0.0.1:8010
- salas         → http://127.0.0.1:8001
- turmas        → http://127.0.0.1:8002
- notas         → http://127.0.0.1:8003

## Como rodar
```bash
python -m venv .venv
# Windows: .venv\Scripts\activate
# Linux/Mac: source .venv/bin/activate

pip install -r requirements.txt
python run_all.py
```

## Teste rápido (curl)
```bash
# health
curl 127.0.0.1:8010/health && echo
curl 127.0.0.1:8001/health && echo
curl 127.0.0.1:8002/health && echo
curl 127.0.0.1:8003/health && echo

# criar turma e matricular
curl -X POST 127.0.0.1:8002/turmas -H "Content-Type: application/json" -d "{\"turma_id\":\"ADS101\",\"professor\":\"simone\"}"
curl -X POST 127.0.0.1:8002/matriculas -H "Content-Type: application/json" -d "{\"turma_id\":\"ADS101\",\"aluno_id\":\"A1\"}"

# agendar aula (via acadêmico 8010)
curl -X POST 127.0.0.1:8010/agendar-aula -H "Content-Type: application/json" -d "{\"turma_id\":\"ADS101\",\"sala\":\"LAB-01\",\"inicio\":\"2025-11-05T19:00\",\"fim\":\"2025-11-05T21:00\"}"

# lançar nota (via acadêmico 8010) e consultar
curl -X POST 127.0.0.1:8010/lancar-nota -H "Content-Type: application/json" -d "{\"turma_id\":\"ADS101\",\"aluno_id\":\"A1\",\"avaliacao\":\"P1\",\"nota\":8.5}"
curl 127.0.0.1:8003/nota/ADS101/A1
```
