extends CanvasLayer

# Notifies `Main` node that the button has been pressed
signal start_game

# Called when the node enters the scene tree for the first time.
func _ready() -> void:
	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta: float) -> void:
	pass

func show_message(text):
	$Message_Label.text = text
	$Message_Label.show()
	$Message_Timer.start()
	
	
func show_game_over():
	show_message("Game Over")
	# Wait until the MessageTimer has counted down.
	await $Message_Timer.timeout

	$Message_Label.text = "Dodge the Creeps!"
	$Message_Label.show()
	# Make a one-shot timer and wait for it to finish.
	await get_tree().create_timer(1.0).timeout
	$Start_Button.show()	


func update_score(score):
	$Score_Label.text = str(score)


func _on_start_button_pressed():
	$Start_Button.hide()
	start_game.emit()

func _on_message_timer_timeout():
	$Message_Label.hide()
